/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_member_base.cc"
 *                                    created: 21/10/97 {2:34:07 pm} 
 *                                last update: 16/12/97 {10:25:13 am} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "cpptcl_member_base.icc"
#include "cpptcl_data_members.h"
#include "cpptcl_fn_members.h"

tcl_object* cpp_mem::container = 0;

Cpptcl_IBaseClass(cpp_mem,"cpp-member",tcl_interaction);
Cpptcl_IBaseClass(cpp_operator_mem,"memberoperator",cpp_mem);

tcl_obj& operator << (tcl_obj& arg, const cpp_mem& mem) {
	if(mem.container) mem.tcl_get(mem.container,arg);
	return arg;
}

tcl_args_reader& operator >> (tcl_args_reader& arg, const cpp_mem& mem) {
	if(mem.container) mem.tcl_set(mem.container,arg);
	return arg;
}

void cpp_mem::get_syntax(tcl_args& arg) const {
	arg("value","set this member to the given value");
}

void cpp_mem::conversion_error(tcl_args& arg) const {
	tcl_obj obuf;
	obuf << " to type '" << data_type() << "'";
	arg.set_conversion_type(obuf);
	arg.syntax("value");
}

int cpp_mem::parse_meta_commands(tcl_obj& tcl_, tcl_args& arg) {
	return tcl_interaction::parse_meta_commands(tcl_,arg);
}

int cpp_mem::configure_member (tcl_args& arg) {
	arg.set_conversion_type(data_type());
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		container = (tcl_object*) arg.container;
		arg.check_read() >> (*this);
		if(!arg.arg_read_ok()) {
			conversion_error(arg);
		}
		arg.check_after();
		arg.parsed_so_far << (*this);
		arg.read_done();
	}
	return arg;
}
