/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import org.eclipse.help.internal.standalone.Eclipse;
import org.eclipse.help.internal.standalone.EclipseConnection;
import org.eclipse.help.internal.standalone.EclipseLifeCycleListener;
import org.eclipse.help.internal.standalone.Options;

public class EclipseController
implements EclipseLifeCycleListener {
    private static final String CONTROL_SERVLET_PATH = "/helpControl/control.html";
    protected String applicationId;
    protected EclipseConnection connection;
    public Eclipse eclipse = null;
    private FileLock lock;
    private boolean eclipseEnded = false;

    public EclipseController(String applicationId, String[] args) {
        this.applicationId = applicationId;
        Options.init(applicationId, args);
        this.connection = new EclipseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void shutdown() throws Exception {
        try {
            this.obtainLock();
            this.sendHelpCommandInternal("shutdown", new String[0]);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws Exception {
        try {
            this.obtainLock();
            this.startEclipse();
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void sendHelpCommand(String command, String[] parameters) throws Exception {
        try {
            this.obtainLock();
            this.sendHelpCommandInternal(command, parameters);
        }
        finally {
            this.releaseLock();
        }
    }

    private void startEclipse() throws Exception {
        boolean fullyRunning = this.isApplicationRunning();
        if (fullyRunning) {
            return;
        }
        if (Options.isDebug()) {
            System.out.println("Using workspace " + Options.getWorkspace().getAbsolutePath());
        }
        Options.getConnectionFile().delete();
        this.connection.reset();
        if (Options.isDebug()) {
            System.out.println("Ensured old .connection file is deleted.  Launching Eclipse.");
        }
        this.eclipseEnded = false;
        this.eclipse = new Eclipse(this);
        this.eclipse.start();
        fullyRunning = this.isApplicationRunning();
        while (!this.eclipseEnded && !fullyRunning) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            fullyRunning = this.isApplicationRunning();
        }
        if (this.eclipseEnded) {
            if (this.eclipse.getStatus() == 2) {
                throw this.eclipse.getException();
            }
            return;
        }
        if (Options.isDebug()) {
            System.out.println("Eclipse launched");
        }
        Runtime.getRuntime().addShutdownHook(new EclipseCleaner());
    }

    private void sendHelpCommandInternal(String command, String[] parameters) throws Exception {
        block8: {
            if (!"shutdown".equalsIgnoreCase(command)) {
                this.startEclipse();
            }
            if (!this.isApplicationRunning()) {
                return;
            }
            if (!this.connection.isValid()) {
                this.connection.renew();
            }
            try {
                URL url = this.createCommandURL(command, parameters);
                if ("shutdown".equalsIgnoreCase(command) && Options.getConnectionFile().exists()) {
                    this.connection.connect(url);
                    long timeLimit = System.currentTimeMillis() + 60000L;
                    while (Options.getConnectionFile().exists()) {
                        Thread.sleep(200L);
                        if (System.currentTimeMillis() <= timeLimit) continue;
                        System.out.println("Shutting down is taking too long.  Will not wait.");
                        break block8;
                    }
                    break block8;
                }
                this.connection.connect(url);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private URL createCommandURL(String command, String[] parameters) throws MalformedURLException {
        StringBuffer urlStr = new StringBuffer();
        urlStr.append("http://");
        urlStr.append(this.connection.getHost());
        urlStr.append(":");
        urlStr.append(this.connection.getPort());
        urlStr.append(CONTROL_SERVLET_PATH);
        urlStr.append("?command=");
        urlStr.append(command);
        for (int i = 0; i < parameters.length; ++i) {
            urlStr.append("&");
            urlStr.append(parameters[i]);
        }
        if (Options.isDebug()) {
            System.out.println("Control servlet URL=" + urlStr.toString());
        }
        return new URL(urlStr.toString());
    }

    public void eclipseEnded() {
        this.eclipseEnded = true;
        this.connection.reset();
    }

    private void obtainLock() throws IOException {
        if (this.lock != null) {
            return;
        }
        if (!Options.getLockFile().exists()) {
            Options.getLockFile().getParentFile().mkdirs();
        }
        RandomAccessFile raf = new RandomAccessFile(Options.getLockFile(), "rw");
        this.lock = raf.getChannel().lock();
        if (Options.isDebug()) {
            System.out.println("Lock obtained.");
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
                if (Options.isDebug()) {
                    System.out.println("Lock released.");
                }
                this.lock = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isApplicationRunning() {
        FileLock applicationLock;
        block24: {
            IOException ioe222;
            RandomAccessFile randomAccessFile;
            block20: {
                File applicationLockFile = new File(Options.getLockFile().getParentFile(), ".applicationlock");
                randomAccessFile = null;
                applicationLock = null;
                randomAccessFile = new RandomAccessFile(applicationLockFile, "rw");
                applicationLock = randomAccessFile.getChannel().tryLock();
                Object var6_4 = null;
                if (applicationLock == null) break block20;
                try {
                    applicationLock.release();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (Options.isDebug()) {
                System.out.println("isApplicationRunning? " + (applicationLock == null));
            }
            break block24;
            {
                catch (IOException ioe3) {
                    IOException ioe222;
                    Object var6_5 = null;
                    if (applicationLock != null) {
                        try {
                            applicationLock.release();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (Options.isDebug()) {
                        System.out.println("isApplicationRunning? " + (applicationLock == null));
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ioe222;
                Object var6_6 = null;
                if (applicationLock != null) {
                    try {
                        applicationLock.release();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (Options.isDebug()) {
                    System.out.println("isApplicationRunning? " + (applicationLock == null));
                }
                throw throwable;
            }
        }
        return applicationLock == null;
    }

    public class EclipseCleaner
    extends Thread {
        public void run() {
            if (EclipseController.this.eclipse != null) {
                EclipseController.this.eclipse.killProcess();
            }
        }
    }
}

