/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.JavaElementLine;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class OccurrencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    protected static final Match[] NO_MATCHES = new Match[0];
    private OccurrencesSearchQuery fQuery;

    public OccurrencesSearchResult(OccurrencesSearchQuery query) {
        this.fQuery = query;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        Object[] elements = this.getElements();
        if (elements.length == 0) {
            return NO_MATCHES;
        }
        JavaElementLine jel = (JavaElementLine)elements[0];
        try {
            if (file.equals(jel.getJavaElement().getCorrespondingResource())) {
                return this.collectMatches(elements);
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)editorInput;
            IClassFile classFile = classFileEditorInput.getClassFile();
            Object[] elements = this.getElements();
            if (elements.length == 0) {
                return NO_MATCHES;
            }
            JavaElementLine jel = (JavaElementLine)elements[0];
            if (jel.getJavaElement().equals(classFile)) {
                return this.collectMatches(elements);
            }
        }
        return NO_MATCHES;
    }

    public IFile getFile(Object element) {
        JavaElementLine jel = (JavaElementLine)element;
        IResource resource = null;
        try {
            resource = jel.getJavaElement().getCorrespondingResource();
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        IJavaElement je = ((JavaElementLine)element).getJavaElement();
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            try {
                return ((IFileEditorInput)editorInput).getFile().equals(je.getCorrespondingResource());
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        if (editorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)editorInput).getClassFile().equals(je);
        }
        return false;
    }

    public String getLabel() {
        int matchCount = this.getMatchCount();
        if (matchCount == 1) {
            return this.fQuery.getSingularLabel();
        }
        String format = this.fQuery.getPluralLabelPattern();
        return MessageFormat.format(format, new Integer(matchCount));
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    private Match[] collectMatches(Object[] elements) {
        Match[] matches = new Match[this.getMatchCount()];
        int writeIndex = 0;
        for (int i = 0; i < elements.length; ++i) {
            Match[] perElement = this.getMatches(elements[i]);
            for (int j = 0; j < perElement.length; ++j) {
                matches[writeIndex++] = perElement[j];
            }
        }
        return matches;
    }
}

