/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIModificationVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIArrayEntryVariable
extends JDIModificationVariable {
    private int fIndex;
    private ArrayReference fArray;
    private String fReferenceTypeName = null;

    public JDIArrayEntryVariable(JDIDebugTarget target, ArrayReference array, int index) {
        super(target);
        this.fArray = array;
        this.fIndex = index;
    }

    protected Value retrieveValue() {
        ArrayReference ar = this.getArrayReference();
        if (ar != null) {
            return ar.getValue(this.getIndex());
        }
        return null;
    }

    public String getName() {
        return "[" + this.getIndex() + "]";
    }

    protected void setValue(Value value) throws DebugException {
        ArrayReference ar = this.getArrayReference();
        if (ar == null) {
            this.requestFailed(JDIDebugModelMessages.getString("JDIArrayEntryVariable.value_modification_failed"), null);
        }
        try {
            ar.setValue(this.getIndex(), value);
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_modifying_variable_value"), e.toString()), e);
        }
        catch (InvalidTypeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_modifying_variable_value_2"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_modifying_variable_value_3"), e.toString()), e);
        }
    }

    protected ArrayReference getArrayReference() {
        return this.fArray;
    }

    protected int getIndex() {
        return this.fIndex;
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            if (this.fReferenceTypeName == null) {
                this.fReferenceTypeName = this.stripBrackets(this.getArrayReference().referenceType().name());
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_retrieving_reference_type"), e.toString()), e);
            return null;
        }
        return this.fReferenceTypeName;
    }

    protected String stripBrackets(String typeName) {
        int lastLeft = typeName.lastIndexOf("[]");
        if (lastLeft < 0) {
            return typeName;
        }
        StringBuffer buffer = new StringBuffer(typeName);
        buffer.replace(lastLeft, lastLeft + 2, "");
        return buffer.toString();
    }

    public String getSignature() throws DebugException {
        try {
            return this.getArrayReference().type().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_retrieving_type_signature"), e.toString()), e);
            return null;
        }
    }

    public void setValue(IValue v) throws DebugException {
        if (this.verifyValue(v)) {
            JDIValue value = (JDIValue)v;
            try {
                this.getArrayReference().setValue(this.getIndex(), value.getUnderlyingValue());
            }
            catch (InvalidTypeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_attempting_to_set_value_of_field"), e.toString()), e);
            }
            catch (ClassNotLoadedException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_attempting_to_set_value_of_field"), e.toString()), e);
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_attempting_to_set_value_of_field"), e.toString()), e);
            }
        }
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return ((ArrayType)this.getArrayReference().type()).componentType();
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_while_retrieving_type_of_array_entry"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayEntryVariable.exception_while_retrieving_type_of_array_entry"), e.toString()), e);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JDIArrayEntryVariable) {
            JDIArrayEntryVariable entry = (JDIArrayEntryVariable)obj;
            return entry.getArrayReference().equals(this.getArrayReference()) && entry.getIndex() == this.getIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.getArrayReference().hashCode() + this.getIndex();
    }
}

