/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTreeContentProvider;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class LaunchConfigurationView
extends AbstractDebugView
implements ILaunchConfigurationListener {
    private Viewer fViewer;
    private LaunchGroupExtension fLaunchGroup;
    private CreateLaunchConfigurationAction fCreateAction;
    private DeleteLaunchConfigurationAction fDeleteAction;
    private DuplicateLaunchConfigurationAction fDuplicateAction;
    private boolean fAutoSelect = true;

    public LaunchConfigurationView(LaunchGroupExtension launchGroup) {
        this.fLaunchGroup = launchGroup;
    }

    protected LaunchGroupExtension getLaunchGroup() {
        return this.fLaunchGroup;
    }

    protected Viewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent);
        treeViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        treeViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        treeViewer.setContentProvider((IContentProvider)new LaunchConfigurationTreeContentProvider(this.fLaunchGroup.getMode(), parent.getShell()));
        treeViewer.addFilter((ViewerFilter)new LaunchGroupFilter(this.getLaunchGroup()));
        treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        treeViewer.expandAll();
        treeViewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                LaunchConfigurationView.this.handleHelpRequest(evt);
            }
        });
        this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        return treeViewer;
    }

    protected void handleHelpRequest(HelpEvent evt) {
        if (this.getTreeViewer().getTree() != evt.getSource()) {
            return;
        }
        try {
            ISelection selection = this.getViewer().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                String helpContextId;
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object firstSelected = structuredSelection.getFirstElement();
                ILaunchConfigurationType configType = null;
                if (firstSelected instanceof ILaunchConfigurationType) {
                    configType = (ILaunchConfigurationType)firstSelected;
                } else if (firstSelected instanceof ILaunchConfiguration) {
                    configType = ((ILaunchConfiguration)firstSelected).getType();
                }
                if (configType != null && (helpContextId = LaunchConfigurationPresentationManager.getDefault().getHelpContext(configType, this.getLaunchGroup().getMode())) != null) {
                    WorkbenchHelp.displayHelp((String)helpContextId);
                }
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
    }

    protected void createActions() {
        this.fCreateAction = new CreateLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION, (IAction)this.fCreateAction);
        this.fDeleteAction = new DeleteLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION, (IAction)this.fDeleteAction);
        this.setAction("Remove_ActionId", (IAction)this.fDeleteAction);
        this.fDuplicateAction = new DuplicateLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION, (IAction)this.fDuplicateAction);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.LAUNCH_CONFIGURATION_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.fCreateAction);
        menu.add((IAction)this.fDuplicateAction);
        menu.add((IAction)this.fDeleteAction);
        menu.add((IContributionItem)new Separator());
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    public void dispose() {
        this.fCreateAction.dispose();
        this.fDeleteAction.dispose();
        this.fDuplicateAction.dispose();
        this.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        try {
            if (configuration.getAttribute(IDebugUIConstants.ATTR_PRIVATE, false)) {
                return;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
            return;
        }
        TreeViewer viewer = this.getTreeViewer();
        viewer.getControl().setRedraw(false);
        try {
            viewer.add((Object)configuration.getType(), (Object)configuration);
            ILaunchConfiguration from = this.getLaunchManager().getMovedFrom(configuration);
            if (from != null) {
                viewer.remove((Object)from);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        viewer.getControl().setRedraw(true);
        if (this.isAutoSelect()) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)configuration), true);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        ILaunchConfiguration to = this.getLaunchManager().getMovedTo(configuration);
        if (to != null) {
            return;
        }
        ILaunchConfigurationType type = null;
        int typeIndex = -1;
        int configIndex = -1;
        TreeItem[] items = this.getTreeViewer().getTree().getItems();
        int numTypes = items.length;
        block0: for (int i = 0; i < numTypes && type == null; ++i) {
            TreeItem typeItem = items[i];
            typeIndex = i;
            TreeItem[] configs = typeItem.getItems();
            int numConfigs = configs.length;
            for (int j = 0; j < numConfigs; ++j) {
                if (!configuration.equals(configs[j].getData())) continue;
                configIndex = j;
                type = (ILaunchConfigurationType)typeItem.getData();
                continue block0;
            }
        }
        this.getTreeViewer().remove((Object)configuration);
        if (this.getViewer().getSelection().isEmpty()) {
            StructuredSelection newSelection = null;
            if (typeIndex != -1 && configIndex != -1) {
                TreeItem[] configItems = this.getTreeViewer().getTree().getItems()[typeIndex].getItems();
                int numItems = configItems.length;
                Object data = null;
                if (numItems > configIndex) {
                    data = configItems[configIndex].getData();
                } else if (numItems > 0) {
                    data = configItems[numItems - 1].getData();
                }
                if (data != null) {
                    newSelection = new StructuredSelection(data);
                }
            }
            if (newSelection == null && type != null) {
                newSelection = new StructuredSelection(type);
            }
            this.getTreeViewer().setSelection(newSelection);
        }
    }

    public void createLaunchDialogControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.createActions();
        this.createContextMenu(this.getViewer().getControl());
        WorkbenchHelp.setHelp((Control)parent, (String)this.getHelpContextId());
        this.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LaunchConfigurationView.this.handleKeyPressed(e);
            }
        });
        if (this.getViewer() instanceof StructuredViewer) {
            ((StructuredViewer)this.getViewer()).addDoubleClickListener((IDoubleClickListener)this);
        }
    }

    public Viewer getViewer() {
        return this.fViewer;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void setAutoSelect(boolean select) {
        this.fAutoSelect = select;
    }

    protected boolean isAutoSelect() {
        return this.fAutoSelect;
    }
}

