/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractTextElement
extends AbstractBaseIntroElement {
    private IntroText introText;

    AbstractTextElement(Element element, Bundle bundle) {
        super(element, bundle);
        this.introText = this.getTextElement(element);
    }

    private IntroText getTextElement(Element element) {
        try {
            NodeList textElements = element.getElementsByTagName("text");
            if (textElements.getLength() == 0) {
                return null;
            }
            IntroText text = new IntroText((Element)textElements.item(0), this.getBundle());
            text.setParent(this);
            return text;
        }
        catch (Exception e) {
            Util.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String getText() {
        if (this.introText != null) {
            return this.introText.getText();
        }
        return null;
    }

    public IntroText getIntroText() {
        return this.introText;
    }

    public int getType() {
        return 96;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractTextElement clone = (AbstractTextElement)super.clone();
        if (this.introText != null) {
            IntroText cloneIntroText = (IntroText)this.introText.clone();
            cloneIntroText.setParent(clone);
            clone.introText = cloneIntroText;
        }
        return clone;
    }
}

