/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;

public class NewWizard
extends Wizard {
    private static final String CATEGORY_SEPARATOR = "/";
    private String categoryId = null;
    private NewWizardSelectionPage mainPage;
    private boolean projectsOnly = false;
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void addPages() {
        NewWizardsRegistryReader rdr = new NewWizardsRegistryReader(this.projectsOnly);
        WizardCollectionElement wizards = rdr.getWizardElements();
        WorkbenchWizardElement[] primary = rdr.getPrimaryWizards();
        if (this.categoryId != null) {
            WizardCollectionElement categories = wizards;
            StringTokenizer familyTokenizer = new StringTokenizer(this.categoryId, CATEGORY_SEPARATOR);
            while (familyTokenizer.hasMoreElements() && (categories = this.getChildWithID(categories, familyTokenizer.nextToken())) != null) {
            }
            if (categories != null) {
                wizards = categories;
            }
        }
        this.mainPage = new NewWizardSelectionPage(this.workbench, this.selection, wizards, primary);
        this.addPage((IWizardPage)this.mainPage);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    private WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] children = parent.getChildren(null);
        for (int i = 0; i < children.length; ++i) {
            WizardCollectionElement currentChild = (WizardCollectionElement)children[i];
            if (!currentChild.getId().equals(id)) continue;
            return currentChild;
        }
        return null;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
        if (this.projectsOnly) {
            this.setWindowTitle(WorkbenchMessages.getString("NewProject.title"));
        } else {
            this.setWindowTitle(WorkbenchMessages.getString("NewWizard.title"));
        }
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_WIZBAN_NEW_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.mainPage.saveWidgetValues();
        return true;
    }

    public void setCategoryId(String id) {
        this.categoryId = id;
    }

    public void setProjectsOnly(boolean b) {
        this.projectsOnly = b;
    }
}

