/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.NavigationHistoryEditorInfo;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.WorkbenchPage;

public class NavigationHistory
implements INavigationHistory {
    private static final int CAPACITY = 50;
    private NavigationHistoryAction backwardAction;
    private NavigationHistoryAction forwardAction;
    private int ignoreEntries;
    private ArrayList history = new ArrayList(50);
    private ArrayList editors = new ArrayList(50);
    private WorkbenchPage page;
    private int activeEntry = 0;

    public NavigationHistory(WorkbenchPage page) {
        this.page = page;
        page.addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IEditorPart editor = (IEditorPart)part;
                    IEditorInput input = editor.getEditorInput();
                    String id = editor.getSite().getId();
                    Iterator e = NavigationHistory.this.editors.iterator();
                    NavigationHistoryEditorInfo info = null;
                    NavigationHistoryEditorInfo currentInfo = null;
                    NavigationHistoryEntry current = NavigationHistory.this.getEntry(NavigationHistory.this.activeEntry);
                    if (current != null) {
                        currentInfo = current.editorInfo;
                    }
                    while (e.hasNext()) {
                        info = (NavigationHistoryEditorInfo)e.next();
                        if (id.equals(info.editorID) && input.equals(info.editorInput)) {
                            if (info == currentInfo) break;
                            info.handlePartClosed();
                            break;
                        }
                        info = null;
                    }
                    if (info == null) {
                        return;
                    }
                    e = NavigationHistory.this.history.iterator();
                    int i = 0;
                    while (e.hasNext()) {
                        NavigationHistoryEntry entry = (NavigationHistoryEntry)e.next();
                        if (entry.editorInfo != info) continue;
                        if (!entry.handlePartClosed()) {
                            if (i < NavigationHistory.this.activeEntry) {
                                NavigationHistory.this.activeEntry--;
                            } else if (i == NavigationHistory.this.activeEntry) {
                                if (i != 0) {
                                    NavigationHistory.this.activeEntry--;
                                }
                            } else {
                                ++i;
                            }
                            e.remove();
                            entry.dispose();
                            continue;
                        }
                        ++i;
                    }
                    NavigationHistory.this.updateActions();
                }
            }
        });
    }

    private Display getDisplay() {
        return this.page.getWorkbenchWindow().getShell().getDisplay();
    }

    public void markEditor(final IEditorPart part) {
        if (this.ignoreEntries > 0 || part == null) {
            return;
        }
        ++this.ignoreEntries;
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                NavigationHistory.this.ignoreEntries--;
                EditorSite site = (EditorSite)part.getEditorSite();
                Control c = site.getPane().getControl();
                if (c == null || c.isDisposed()) {
                    return;
                }
                NavigationHistoryEntry e = NavigationHistory.this.getEntry(NavigationHistory.this.activeEntry);
                if (e != null && part.getEditorInput() != e.editorInfo.editorInput) {
                    NavigationHistory.this.updateEntry(e);
                }
                NavigationHistory.this.addEntry(part, true);
            }
        });
    }

    public void markLocation(IEditorPart part) {
        this.addEntry(part, true);
    }

    NavigationHistoryEntry[] getBackwardEntries() {
        int length = this.activeEntry;
        NavigationHistoryEntry[] entries = new NavigationHistoryEntry[length];
        for (int i = 0; i < this.activeEntry; ++i) {
            entries[this.activeEntry - 1 - i] = this.getEntry(i);
        }
        return entries;
    }

    NavigationHistoryEntry[] getForwardEntries() {
        int length = this.history.size() - this.activeEntry - 1;
        length = Math.max(0, length);
        NavigationHistoryEntry[] entries = new NavigationHistoryEntry[length];
        for (int i = this.activeEntry + 1; i < this.history.size(); ++i) {
            entries[i - this.activeEntry - 1] = this.getEntry(i);
        }
        return entries;
    }

    public INavigationLocation[] getLocations() {
        INavigationLocation[] result = new INavigationLocation[this.history.size()];
        for (int i = 0; i < result.length; ++i) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.get(i);
            result[i] = e.location;
        }
        return result;
    }

    public INavigationLocation getCurrentLocation() {
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        return entry == null ? null : entry.location;
    }

    public void dispose() {
        Iterator e = this.history.iterator();
        while (e.hasNext()) {
            NavigationHistoryEntry entry = (NavigationHistoryEntry)e.next();
            this.disposeEntry(entry);
        }
    }

    public void setForwardAction(NavigationHistoryAction action) {
        this.forwardAction = action;
        this.updateActions();
    }

    public void setBackwardAction(NavigationHistoryAction action) {
        this.backwardAction = action;
        this.updateActions();
    }

    private NavigationHistoryEntry getEntry(int index) {
        if (0 <= index && index < this.history.size()) {
            return (NavigationHistoryEntry)this.history.get(index);
        }
        return null;
    }

    private void add(NavigationHistoryEntry entry) {
        this.removeForwardEntries();
        if (this.history.size() == 50) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.remove(0);
            this.disposeEntry(e);
        }
        this.history.add(entry);
        this.activeEntry = this.history.size() - 1;
    }

    private void removeForwardEntries() {
        int length = this.history.size();
        for (int i = this.activeEntry + 1; i < length; ++i) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.remove(this.activeEntry + 1);
            this.disposeEntry(e);
        }
    }

    private void addEntry(IEditorPart part, boolean markLocation) {
        NavigationHistoryEntry current;
        if (this.ignoreEntries > 0 || part == null) {
            return;
        }
        INavigationLocation location = null;
        if (markLocation && part instanceof INavigationLocationProvider) {
            location = ((INavigationLocationProvider)((Object)part)).createNavigationLocation();
        }
        if ((current = this.getEntry(this.activeEntry)) != null && current.editorInfo.memento != null) {
            current.editorInfo.restoreEditor();
            this.checkDuplicates(current.editorInfo);
        }
        NavigationHistoryEntry e = this.createEntry(this.page, part, location);
        if (current == null) {
            this.add(e);
        } else if (e.mergeInto(current)) {
            this.disposeEntry(e);
            this.removeForwardEntries();
        } else {
            this.add(e);
        }
        this.printEntries("added entry");
        this.updateActions();
    }

    private void printEntries(String label) {
    }

    boolean canForward() {
        return 0 <= this.activeEntry + 1 && this.activeEntry + 1 < this.history.size();
    }

    boolean canBackward() {
        return 0 <= this.activeEntry - 1 && this.activeEntry - 1 < this.history.size();
    }

    private void updateActions() {
        if (this.backwardAction != null) {
            this.backwardAction.update();
        }
        if (this.forwardAction != null) {
            this.forwardAction.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoEntry(NavigationHistoryEntry entry) {
        if (entry == null) {
            return;
        }
        try {
            ++this.ignoreEntries;
            if (entry.editorInfo.memento != null) {
                entry.editorInfo.restoreEditor();
                this.checkDuplicates(entry.editorInfo);
            }
            entry.restoreLocation();
            this.updateActions();
            this.printEntries("goto entry");
        }
        finally {
            --this.ignoreEntries;
        }
    }

    private void updateEntry(NavigationHistoryEntry activeEntry) {
        if (activeEntry == null || activeEntry.location == null) {
            return;
        }
        activeEntry.location.update();
        this.printEntries("updateEntry");
    }

    public void forward() {
        if (this.canForward()) {
            this.shiftEntry(true);
        }
    }

    public void backward() {
        if (this.canBackward()) {
            this.shiftEntry(false);
        }
    }

    private void shiftEntry(boolean forward) {
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = forward ? ++this.activeEntry : --this.activeEntry;
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        if (entry != null) {
            this.gotoEntry(entry);
        }
    }

    protected void shiftCurrentEntry(NavigationHistoryEntry entry) {
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = this.history.indexOf(entry);
        this.gotoEntry(entry);
    }

    void saveState(IMemento memento) {
        NavigationHistoryEntry entry;
        int i;
        NavigationHistoryEntry cEntry = this.getEntry(this.activeEntry);
        if (cEntry == null || !cEntry.editorInfo.isPersistable()) {
            return;
        }
        ArrayList editors = (ArrayList)this.editors.clone();
        Iterator iter = editors.iterator();
        while (iter.hasNext()) {
            NavigationHistoryEditorInfo info = (NavigationHistoryEditorInfo)iter.next();
            if (info.isPersistable()) continue;
            iter.remove();
        }
        IMemento editorsMem = memento.createChild("editors");
        Iterator iter2 = editors.iterator();
        while (iter2.hasNext()) {
            NavigationHistoryEditorInfo info = (NavigationHistoryEditorInfo)iter2.next();
            info.saveState(editorsMem.createChild("editor"));
        }
        ArrayList<NavigationHistoryEntry> list = new ArrayList<NavigationHistoryEntry>(this.history.size());
        int size = this.history.size();
        for (i = 0; i < size; ++i) {
            entry = (NavigationHistoryEntry)this.history.get(i);
            if (!entry.editorInfo.isPersistable()) continue;
            list.add(entry);
        }
        size = list.size();
        for (i = 0; i < size; ++i) {
            entry = (NavigationHistoryEntry)list.get(i);
            IMemento childMem = memento.createChild("item");
            if (entry == cEntry) {
                childMem.putString("active", "true");
            }
            entry.saveState(childMem, list);
            childMem.putInteger("index", editors.indexOf(entry.editorInfo));
        }
    }

    void restoreState(IMemento memento) {
        int i;
        IMemento editorsMem = memento.getChild("editors");
        IMemento[] items = memento.getChildren("item");
        if (items.length == 0 || editorsMem == null) {
            if (this.page.getActiveEditor() != null) {
                this.markLocation(this.page.getActiveEditor());
            }
            return;
        }
        IMemento[] children = editorsMem.getChildren("editor");
        NavigationHistoryEditorInfo[] editorsInfo = new NavigationHistoryEditorInfo[children.length];
        for (i = 0; i < editorsInfo.length; ++i) {
            editorsInfo[i] = new NavigationHistoryEditorInfo(children[i]);
            this.editors.add(editorsInfo[i]);
        }
        for (i = 0; i < items.length; ++i) {
            IMemento item = items[i];
            int index = item.getInteger("index");
            NavigationHistoryEditorInfo info = editorsInfo[index];
            ++info.refCount;
            NavigationHistoryEntry entry = new NavigationHistoryEntry(info, this.page, null, null);
            this.history.add(entry);
            entry.restoreState(item);
            if (item.getString("active") == null) continue;
            this.activeEntry = i;
        }
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        if (entry != null && entry.editorInfo.editorInput != null && this.page.getActiveEditor() == this.page.findEditor(entry.editorInfo.editorInput)) {
            this.gotoEntry(entry);
        }
    }

    public NavigationHistoryEntry createEntry(IWorkbenchPage page, IEditorPart part, INavigationLocation location) {
        String editorID = part.getSite().getId();
        IEditorInput editorInput = part.getEditorInput();
        NavigationHistoryEditorInfo info = null;
        Iterator iter = this.editors.iterator();
        while (iter.hasNext()) {
            info = (NavigationHistoryEditorInfo)iter.next();
            if (editorID.equals(info.editorID) && editorInput.equals(info.editorInput)) {
                ++info.refCount;
                break;
            }
            info = null;
        }
        if (info == null) {
            info = new NavigationHistoryEditorInfo(part);
            ++info.refCount;
            this.editors.add(info);
        }
        return new NavigationHistoryEntry(info, page, part, location);
    }

    public void disposeEntry(NavigationHistoryEntry entry) {
        if (entry.editorInfo == null) {
            return;
        }
        --entry.editorInfo.refCount;
        if (entry.editorInfo.refCount == 0) {
            this.editors.remove(entry.editorInfo);
        }
        entry.dispose();
    }

    void checkDuplicates(NavigationHistoryEditorInfo info) {
        NavigationHistoryEditorInfo dup = null;
        if (info.editorInput == null) {
            return;
        }
        Iterator iter = this.editors.iterator();
        while (!(!iter.hasNext() || info != (dup = (NavigationHistoryEditorInfo)iter.next()) && info.editorID.equals(dup.editorID) && info.editorInput.equals(dup.editorInput))) {
            dup = null;
        }
        if (dup == null) {
            return;
        }
        iter = this.history.iterator();
        while (iter.hasNext()) {
            NavigationHistoryEntry entry = (NavigationHistoryEntry)iter.next();
            if (entry.editorInfo != dup) continue;
            entry.editorInfo = info;
            ++info.refCount;
        }
        this.editors.remove(dup);
    }
}

