/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;

public abstract class Page {
    protected Composite cheatSheetComposite;
    protected static final int HORZ_SCROLL_INCREMENT = 20;
    protected static final int VERT_SCROLL_INCREMENT = 20;
    protected Color backgroundColor;
    private Color[] colorArray;
    private final RGB bottomRGB = new RGB(255, 255, 255);
    private final RGB midRGB = new RGB(242, 252, 254);
    private final RGB topRGB = new RGB(232, 242, 254);
    protected FormToolkit toolkit;
    protected ScrolledForm form;

    public Control getControl() {
        return this.cheatSheetComposite;
    }

    public void createPart(Composite parent) {
        this.init(parent.getDisplay());
        this.cheatSheetComposite = new Composite(parent, 0);
        this.cheatSheetComposite.setRedraw(false);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 1;
        this.cheatSheetComposite.setLayout((Layout)layout);
        this.cheatSheetComposite.setBackground(this.backgroundColor);
        this.cheatSheetComposite.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(this.cheatSheetComposite);
        this.createInfoArea(this.cheatSheetComposite);
        this.cheatSheetComposite.setRedraw(true);
    }

    protected void createInfoArea(Composite parent) {
        CheatSheetStopWatch.startStopWatch("Page.createInfoArea()");
        this.toolkit = new FormToolkit(parent.getDisplay());
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after new FormToolkit(): ");
        this.form = this.toolkit.createScrolledForm(parent);
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after createScrolledForm(): ");
        this.form.setLayoutData((Object)new GridData(1808));
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after setLayoutData(): ");
        TableWrapLayout layout = new TableWrapLayout();
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after new FormTableWrapLayout(): ");
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        this.form.getBody().setLayout((Layout)layout);
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() end of method: ");
    }

    private void createTitleArea(Composite parent) {
        final CLabel messageLabel = new CLabel(parent, 0);
        messageLabel.setBackground(this.colorArray, new int[]{85, 100}, true);
        messageLabel.setText(this.getTitle());
        messageLabel.setFont(JFaceResources.getHeaderFont());
        GridData ldata = new GridData(768);
        ldata.grabExcessHorizontalSpace = true;
        messageLabel.setLayoutData((Object)ldata);
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.headerfont".equals(event.getProperty())) {
                    messageLabel.setFont(JFaceResources.getHeaderFont());
                }
            }
        };
        messageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gridData = new GridData(768);
        messageLabel.setLayoutData((Object)gridData);
    }

    public void dispose() {
        for (int i = 0; i < this.colorArray.length; ++i) {
            if (this.colorArray[i] == null) continue;
            this.colorArray[i].dispose();
        }
        if (this.cheatSheetComposite != null) {
            this.cheatSheetComposite.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    protected void init(Display display) {
        this.backgroundColor = JFaceColors.getBannerBackground((Display)display);
        this.colorArray = new Color[]{new Color((Device)display, this.topRGB), new Color((Device)display, this.midRGB), new Color((Device)display, this.bottomRGB)};
    }

    protected abstract String getTitle();
}

