/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

public class ScopeAnalyzer {
    public static final int METHODS = 1;
    public static final int VARIABLES = 2;
    public static final int TYPES = 4;
    public static final int CHECK_VISIBILITY = 16;
    private ArrayList fRequestor = new ArrayList();
    private HashSet fNamesAdded = new HashSet();
    private HashSet fTypesVisited = new HashSet();
    private CompilationUnit fRoot;

    public ScopeAnalyzer(CompilationUnit root) {
        this.fRoot = root;
    }

    protected void addResult(IBinding binding) {
        String signature = ScopeAnalyzer.getSignature(binding);
        if (signature != null && this.fNamesAdded.add(signature)) {
            this.fRequestor.add(binding);
        }
    }

    private void clearLists() {
        this.fRequestor.clear();
        this.fNamesAdded.clear();
        this.fTypesVisited.clear();
    }

    private static String getSignature(IBinding binding) {
        if (binding != null) {
            switch (binding.getKind()) {
                case 4: {
                    StringBuffer buf = new StringBuffer();
                    buf.append('M');
                    buf.append(binding.getName()).append('(');
                    ITypeBinding[] parameters = ((IMethodBinding)binding).getParameterTypes();
                    for (int i = 0; i < parameters.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(parameters[i].getQualifiedName());
                    }
                    buf.append(')');
                    return buf.toString();
                }
                case 3: {
                    return 'V' + binding.getName();
                }
                case 2: {
                    return 'T' + binding.getName();
                }
            }
        }
        return null;
    }

    private boolean hasFlag(int property, int flags) {
        return (flags & property) != 0;
    }

    private void addInherited(ITypeBinding binding, int flags) {
        ITypeBinding superClass;
        IMethodBinding curr;
        int i;
        if (!this.fTypesVisited.add(binding)) {
            return;
        }
        if (this.hasFlag(2, flags)) {
            IVariableBinding[] variableBindings = binding.getDeclaredFields();
            for (i = 0; i < variableBindings.length; ++i) {
                this.addResult((IBinding)variableBindings[i]);
            }
        }
        if (this.hasFlag(1, flags)) {
            IMethodBinding[] methodBindings = binding.getDeclaredMethods();
            for (i = 0; i < methodBindings.length; ++i) {
                curr = methodBindings[i];
                if (curr.isSynthetic() || curr.isConstructor()) continue;
                this.addResult((IBinding)curr);
            }
        }
        if (this.hasFlag(4, flags)) {
            ITypeBinding[] typeBindings = binding.getDeclaredTypes();
            for (i = 0; i < typeBindings.length; ++i) {
                curr = typeBindings[i];
                this.addResult((IBinding)curr);
            }
        }
        if ((superClass = binding.getSuperclass()) != null) {
            this.addInherited(superClass, flags);
        } else if (binding.isArray()) {
            this.addInherited(this.fRoot.getAST().resolveWellKnownType("java.lang.Object"), flags);
        }
        if (this.hasFlag(6, flags)) {
            ITypeBinding[] interfaces = binding.getInterfaces();
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                this.addInherited(interfaces[i2], flags & 6);
            }
        }
    }

    private void addTypeDeclarations(ITypeBinding binding, int flags) {
        if (this.hasFlag(4, flags) && !binding.isAnonymous()) {
            this.addResult((IBinding)binding);
        }
        this.addInherited(binding, flags);
        if (binding.isLocal()) {
            this.addOuterDeclarationsForLocalType(binding, flags);
        } else {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass != null) {
                this.addTypeDeclarations(declaringClass, flags);
            } else if (this.hasFlag(4, flags) && this.fRoot.findDeclaringNode((IBinding)binding) != null) {
                List types = this.fRoot.types();
                for (int i = 0; i < types.size(); ++i) {
                    TypeDeclaration decl = (TypeDeclaration)types.get(i);
                    this.addResult((IBinding)decl.resolveBinding());
                }
            }
        }
    }

    private void addOuterDeclarationsForLocalType(ITypeBinding localBinding, int flags) {
        ASTNode node = this.fRoot.findDeclaringNode((IBinding)localBinding);
        if (node == null) {
            return;
        }
        if (node instanceof TypeDeclaration || node instanceof AnonymousClassDeclaration) {
            this.addLocalDeclarations(node.getParent(), flags);
            ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType(node.getParent());
            if (parentTypeBinding != null) {
                this.addTypeDeclarations(parentTypeBinding, flags);
            }
        }
    }

    private static ITypeBinding getBinding(Expression node) {
        if (node != null) {
            return node.resolveTypeBinding();
        }
        return null;
    }

    private static ITypeBinding getQualifier(SimpleName selector) {
        ASTNode parent = selector.getParent();
        switch (parent.getNodeType()) {
            case 32: {
                MethodInvocation decl = (MethodInvocation)parent;
                if (selector == decl.getName()) {
                    return ScopeAnalyzer.getBinding(decl.getExpression());
                }
                return null;
            }
            case 40: {
                QualifiedName qualifiedName = (QualifiedName)parent;
                if (selector == qualifiedName.getName()) {
                    return ScopeAnalyzer.getBinding((Expression)qualifiedName.getQualifier());
                }
                return null;
            }
            case 22: {
                FieldAccess fieldAccess = (FieldAccess)parent;
                if (selector == fieldAccess.getName()) {
                    return ScopeAnalyzer.getBinding(fieldAccess.getExpression());
                }
                return null;
            }
            case 47: 
            case 48: {
                ITypeBinding curr = Bindings.getBindingOfParentType(parent);
                return curr.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinding[] getDeclarationsInScope(SimpleName selector, int flags) {
        try {
            ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType((ASTNode)selector);
            ITypeBinding binding = ScopeAnalyzer.getQualifier(selector);
            if (binding == null) {
                this.addLocalDeclarations((ASTNode)selector, flags);
                binding = parentTypeBinding;
            }
            if (binding != null) {
                this.addTypeDeclarations(binding, flags);
            }
            if (this.hasFlag(16, flags)) {
                this.firterNonVisible(parentTypeBinding);
            }
            IBinding[] iBindingArray = this.fRequestor.toArray(new IBinding[this.fRequestor.size()]);
            return iBindingArray;
        }
        finally {
            this.clearLists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinding[] getDeclarationsInScope(int offset, int flags) {
        NodeFinder finder = new NodeFinder(offset, 0);
        this.fRoot.accept((ASTVisitor)finder);
        ASTNode node = finder.getCoveringNode();
        if (node == null) {
            return null;
        }
        if (node instanceof SimpleName) {
            return this.getDeclarationsInScope((SimpleName)node, flags);
        }
        try {
            this.addLocalDeclarations(node, offset, flags);
            ITypeBinding binding = Bindings.getBindingOfParentType(node);
            if (binding != null) {
                this.addTypeDeclarations(binding, flags);
            }
            if (this.hasFlag(16, flags)) {
                this.firterNonVisible(binding);
            }
            IBinding[] iBindingArray = this.fRequestor.toArray(new IBinding[this.fRequestor.size()]);
            return iBindingArray;
        }
        finally {
            this.clearLists();
        }
    }

    private void firterNonVisible(ITypeBinding binding) {
        for (int i = this.fRequestor.size() - 1; i >= 0; --i) {
            if (ScopeAnalyzer.isVisible((IBinding)this.fRequestor.get(i), binding)) continue;
            this.fRequestor.remove(i);
        }
    }

    private static ITypeBinding getDeclaringType(IBinding binding) {
        switch (binding.getKind()) {
            case 3: {
                return ((IVariableBinding)binding).getDeclaringClass();
            }
            case 4: {
                return ((IMethodBinding)binding).getDeclaringClass();
            }
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.getDeclaringClass() != null) {
                    return typeBinding;
                }
                return typeBinding;
            }
        }
        return null;
    }

    public static boolean isVisible(IBinding binding, ITypeBinding context) {
        if (binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
            return true;
        }
        ITypeBinding declaring = ScopeAnalyzer.getDeclaringType(binding);
        if (declaring == null) {
            return false;
        }
        int modifiers = binding.getModifiers();
        if (Modifier.isPublic((int)modifiers) || declaring.isInterface()) {
            return true;
        }
        if (Modifier.isProtected((int)modifiers) || !Modifier.isPrivate((int)modifiers)) {
            if (declaring != null && declaring.getPackage() == context.getPackage()) {
                return true;
            }
            return ScopeAnalyzer.isTypeInScope(declaring, context, Modifier.isProtected((int)modifiers));
        }
        return ScopeAnalyzer.isTypeInScope(declaring, context, false);
    }

    private static boolean isTypeInScope(ITypeBinding declaring, ITypeBinding context, boolean includeHierarchy) {
        ITypeBinding curr;
        for (curr = context; curr != null && curr != declaring; curr = curr.getDeclaringClass()) {
            if (!includeHierarchy || !Bindings.isSuperType(declaring, curr)) continue;
            return true;
        }
        return curr == declaring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinding[] getDeclarationsAfter(int offset, int flags) {
        try {
            NodeFinder finder = new NodeFinder(offset, 0);
            this.fRoot.accept((ASTVisitor)finder);
            ASTNode node = finder.getCoveringNode();
            if (node == null) {
                IBinding[] iBindingArray = null;
                return iBindingArray;
            }
            Statement declaration = ASTResolving.findParentStatement(node);
            while (declaration instanceof Statement && declaration.getNodeType() != 8) {
                declaration = declaration.getParent();
            }
            if (declaration instanceof Block) {
                DeclarationsAfterVisitor visitor = new DeclarationsAfterVisitor(node.getStartPosition(), flags);
                declaration.accept((ASTVisitor)visitor);
            }
            IBinding[] iBindingArray = this.fRequestor.toArray(new IBinding[this.fRequestor.size()]);
            return iBindingArray;
        }
        finally {
            this.clearLists();
        }
    }

    private void addLocalDeclarations(ASTNode node, int flags) {
        this.addLocalDeclarations(node, node.getStartPosition(), flags);
    }

    private void addLocalDeclarations(ASTNode node, int offset, int flags) {
        BodyDeclaration declaration;
        if ((this.hasFlag(2, flags) || this.hasFlag(4, flags)) && ((declaration = ASTResolving.findParentBodyDeclaration(node)) instanceof MethodDeclaration || declaration instanceof Initializer)) {
            ScopeAnalyzerVisitor visitor = new ScopeAnalyzerVisitor(offset, flags);
            declaration.accept((ASTVisitor)visitor);
        }
    }

    private class DeclarationsAfterVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private int fFlags;

        public DeclarationsAfterVisitor(int position, int flags) {
            this.fPosition = position;
            this.fFlags = flags;
        }

        public boolean visit(ASTNode node) {
            return true;
        }

        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.this.hasFlag(2, this.fFlags) && this.fPosition < node.getStartPosition()) {
                ScopeAnalyzer.this.addResult((IBinding)node.resolveBinding());
            }
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.this.hasFlag(4, this.fFlags) && this.fPosition < node.getStartPosition()) {
                ScopeAnalyzer.this.addResult((IBinding)node.getTypeDeclaration().resolveBinding());
            }
            return false;
        }
    }

    private class ScopeAnalyzerVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private int fFlags;

        public ScopeAnalyzerVisitor(int position, int flags) {
            this.fPosition = position;
            this.fFlags = flags;
        }

        private boolean isInside(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            return start <= this.fPosition && this.fPosition < end;
        }

        public boolean visit(MethodDeclaration node) {
            if (this.isInside((ASTNode)node)) {
                Block body = node.getBody();
                if (body != null) {
                    body.accept((ASTVisitor)this);
                }
                this.visitBackwards(node.parameters());
            }
            return false;
        }

        public boolean visit(Initializer node) {
            return this.isInside((ASTNode)node);
        }

        public boolean visit(Statement node) {
            return this.isInside((ASTNode)node);
        }

        public boolean visit(ASTNode node) {
            return false;
        }

        public boolean visit(Block node) {
            if (this.isInside((ASTNode)node)) {
                this.visitBackwards(node.statements());
            }
            return false;
        }

        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.this.hasFlag(2, this.fFlags) && node.getStartPosition() < this.fPosition) {
                ScopeAnalyzer.this.addResult((IBinding)node.resolveBinding());
            }
            return false;
        }

        public boolean visit(VariableDeclarationStatement node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        public boolean visit(CatchClause node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                node.getException().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ForStatement node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                this.visitBackwards(node.initializers());
            }
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.this.hasFlag(4, this.fFlags) && node.getStartPosition() + node.getLength() < this.fPosition) {
                ScopeAnalyzer.this.addResult((IBinding)node.getTypeDeclaration().resolveBinding());
                return false;
            }
            return this.isInside((ASTNode)node);
        }

        private void visitBackwards(List list) {
            for (int i = list.size() - 1; i >= 0; --i) {
                ASTNode curr = (ASTNode)list.get(i);
                if (curr.getStartPosition() >= this.fPosition) continue;
                curr.accept((ASTVisitor)this);
            }
        }
    }
}

