/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.IWorkbenchPart;

public class CommitOperation
extends SingleCommandOperation {
    public CommitOperation(IWorkbenchPart part, IResource[] resources, Command.LocalOption[] options) {
        super(part, resources, options);
    }

    public boolean performPrompting(IProgressMonitor monitor) throws CVSException, InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 20);
        IResource[] resourcesToBeAdded = this.promptForResourcesToBeAdded(Policy.subMonitorFor(monitor, 10));
        String comment = this.promptForComment(this.getResources());
        if (comment == null) {
            return false;
        }
        this.addLocalOption(Commit.makeArgumentOption((Command.LocalOption)Command.MESSAGE_OPTION, (String)comment));
        if (resourcesToBeAdded.length > 0) {
            new AddOperation(this.getPart(), resourcesToBeAdded).run(Policy.subMonitorFor(monitor, 10));
        }
        this.setResources(this.getSharedResources(this.getResources()));
        monitor.done();
        return true;
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        if (!Command.MESSAGE_OPTION.isElementOf((Command.Option[])this.getLocalOptions())) {
            String comment = this.promptForComment(this.getResources());
            if (comment == null) {
                return;
            }
            this.addLocalOption(Commit.makeArgumentOption((Command.LocalOption)Command.MESSAGE_OPTION, (String)comment));
        }
        super.execute(monitor);
    }

    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        return Command.COMMIT.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(), resources, null, monitor);
    }

    protected void handleErrors(IStatus[] errors) throws CVSException {
        ArrayList<IStatus> serverErrors = new ArrayList<IStatus>();
        for (int i = 0; i < errors.length; ++i) {
            IStatus status = errors[i];
            if (status.getCode() != -10) continue;
            serverErrors.add(status);
        }
        if (serverErrors.isEmpty()) {
            return;
        }
        super.handleErrors(serverErrors.toArray(new IStatus[serverErrors.size()]));
    }

    protected String getTaskName() {
        return Policy.bind("RepositoryManager.committing");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("CommitOperation.0", provider.getProject().getName());
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return Policy.bind("CommitAction.commitFailed");
    }

    private IResource[] getUnaddedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws CVSException {
        final ArrayList unadded = new ArrayList();
        final CVSException[] exception = new CVSException[]{null};
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                        try {
                            if (cvsResource.isIgnored()) {
                                return false;
                            }
                            if (cvsResource.isManaged()) {
                                return true;
                            }
                            if (cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder()) {
                                return true;
                            }
                        }
                        catch (CVSException e) {
                            exception[0] = e;
                        }
                        if (resource.getType() == 2) {
                            return true;
                        }
                        unadded.add(resource);
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
            if (exception[0] == null) continue;
            throw exception[0];
        }
        return unadded.toArray(new IResource[unadded.size()]);
    }

    protected IResource[] promptForResourcesToBeAdded(IProgressMonitor monitor) throws CVSException {
        IResource[] unadded = this.getUnaddedResources(this.getResources(), monitor);
        RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        return manager.promptForResourcesToBeAdded(this.getShell(), unadded);
    }

    protected String promptForComment(IResource[] resourcesToCommit) {
        RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        return manager.promptForComment(this.getShell(), resourcesToCommit);
    }

    private IResource[] getSharedResources(IResource[] resources) throws CVSException {
        ArrayList<IResource> shared = new ArrayList<IResource>();
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (!cvsResource.isManaged() && (!cvsResource.isFolder() || !((ICVSFolder)cvsResource).isCVSFolder())) continue;
            shared.add(resource);
        }
        return shared.toArray(new IResource[shared.size()]);
    }

    protected boolean isServerModificationOperation() {
        return true;
    }
}

