/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.util.List;
import org.apache.tools.ant.Target;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntImportNode;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.editor.model.AntTargetNode;
import org.eclipse.ant.internal.ui.editor.model.AntTaskNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.AntOutlineMessages;
import org.eclipse.ant.internal.ui.editor.outline.DocumentModelChangeEvent;
import org.eclipse.ant.internal.ui.editor.outline.FilterImportedElementsAction;
import org.eclipse.ant.internal.ui.editor.outline.FilterInternalTargetsAction;
import org.eclipse.ant.internal.ui.editor.outline.FilterPropertiesAction;
import org.eclipse.ant.internal.ui.editor.outline.FilterTopLevelAction;
import org.eclipse.ant.internal.ui.editor.outline.IDocumentModelListener;
import org.eclipse.ant.internal.ui.editor.outline.ToggleLinkWithEditorAction;
import org.eclipse.ant.internal.ui.editor.outline.ToggleSortAntOutlineAction;
import org.eclipse.ant.internal.ui.editor.outline.XMLCore;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.views.actions.AntOpenWithMenu;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AntEditorContentOutlinePage
extends ContentOutlinePage
implements IShowInSource,
IAdaptable {
    private static final int EXPAND_TO_LEVEL = 2;
    private Menu menu;
    private AntOpenWithMenu openWithMenu;
    private IDocumentModelListener fListener;
    private AntModel fModel;
    private XMLCore fCore;
    private ListenerList fPostSelectionChangedListeners = new ListenerList();
    private boolean fIsModelEmpty = true;
    private boolean fFilterInternalTargets;
    private InternalTargetFilter fInternalTargetFilter = null;
    private boolean fFilterImportedElements;
    private ImportedElementsFilter fImportedElementsFilter = null;
    private boolean fFilterProperties;
    private PropertiesFilter fPropertiesFilter = null;
    private boolean fFilterTopLevel;
    private TopLevelFilter fTopLevelFilter = null;
    private boolean fSort;
    private ViewerSorter fSorter;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private AntEditor fEditor;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInSource;

    protected void setFilterInternalTargets(boolean filter) {
        this.fFilterInternalTargets = filter;
        this.setFilter(filter, this.getInternalTargetsFilter(), "anteditor.filterInternalTargets");
    }

    protected void setFilterImportedElements(boolean filter) {
        this.fFilterImportedElements = filter;
        this.setFilter(filter, this.getImportedElementsFilter(), "anteditor.filterImportedElements");
    }

    private void setFilter(boolean filter, ViewerFilter viewerFilter, String name) {
        if (filter) {
            this.getTreeViewer().addFilter(viewerFilter);
        } else {
            this.getTreeViewer().removeFilter(viewerFilter);
        }
        AntUIPlugin.getDefault().getPreferenceStore().setValue(name, filter);
        this.getTreeViewer().refresh();
    }

    protected void setFilterProperties(boolean filter) {
        this.fFilterProperties = filter;
        this.setFilter(filter, this.getPropertiesFilter(), "anteditor.filterProperties");
    }

    protected void setFilterTopLevel(boolean filter) {
        this.fFilterTopLevel = filter;
        this.setFilter(filter, this.getTopLevelFilter(), "anteditor.filterTopLevel");
    }

    private ViewerFilter getInternalTargetsFilter() {
        if (this.fInternalTargetFilter == null) {
            this.fInternalTargetFilter = new InternalTargetFilter();
        }
        return this.fInternalTargetFilter;
    }

    private ViewerFilter getImportedElementsFilter() {
        if (this.fImportedElementsFilter == null) {
            this.fImportedElementsFilter = new ImportedElementsFilter();
        }
        return this.fImportedElementsFilter;
    }

    private ViewerFilter getPropertiesFilter() {
        if (this.fPropertiesFilter == null) {
            this.fPropertiesFilter = new PropertiesFilter();
        }
        return this.fPropertiesFilter;
    }

    private ViewerFilter getTopLevelFilter() {
        if (this.fTopLevelFilter == null) {
            this.fTopLevelFilter = new TopLevelFilter();
        }
        return this.fTopLevelFilter;
    }

    protected boolean filterInternalTargets() {
        return this.fFilterInternalTargets;
    }

    protected boolean filterImportedElements() {
        return this.fFilterImportedElements;
    }

    protected boolean filterProperties() {
        return this.fFilterProperties;
    }

    protected boolean filterTopLevel() {
        return this.fFilterTopLevel;
    }

    protected void setSort(boolean sort) {
        this.fSort = sort;
        if (sort) {
            if (this.fSorter == null) {
                this.fSorter = new AntOutlineSorter();
            }
            this.getTreeViewer().setSorter(this.fSorter);
        } else {
            this.getTreeViewer().setSorter(null);
        }
        AntUIPlugin.getDefault().getPreferenceStore().setValue("anteditor.sort", sort);
    }

    protected boolean isSort() {
        return this.fSort;
    }

    public AntEditorContentOutlinePage(XMLCore core, AntEditor editor) {
        this.fCore = core;
        this.fFilterInternalTargets = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterInternalTargets");
        this.fFilterImportedElements = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterImportedElements");
        this.fFilterProperties = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterProperties");
        this.fFilterTopLevel = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.filterTopLevel");
        this.fSort = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("anteditor.sort");
        this.fEditor = editor;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
        if (this.openWithMenu != null) {
            this.openWithMenu.dispose();
        }
        if (this.fListener != null) {
            this.fCore.removeDocumentModelListener(this.fListener);
            this.fListener = null;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.setSort(this.fSort);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        if (this.fModel != null) {
            this.setViewerInput(this.fModel);
        }
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                AntEditorContentOutlinePage.this.contextMenuAboutToShow(menuManager);
            }
        });
        this.menu = manager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(this.menu);
        IPageSite site = this.getSite();
        site.registerContextMenu("org.eclipse.ant.ui.antEditorOutline", manager, (ISelectionProvider)viewer);
        IToolBarManager tbm = site.getActionBars().getToolBarManager();
        tbm.add((IAction)new ToggleSortAntOutlineAction(this));
        tbm.add((IAction)new FilterInternalTargetsAction(this));
        tbm.add((IAction)new FilterPropertiesAction(this));
        tbm.add((IAction)new FilterImportedElementsAction(this));
        tbm.add((IAction)new FilterTopLevelAction(this));
        IMenuManager viewMenu = site.getActionBars().getMenuManager();
        viewMenu.add((IAction)new ToggleLinkWithEditorAction(this.fEditor));
        this.openWithMenu = new AntOpenWithMenu(this.getSite().getPage());
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntEditorContentOutlinePage.this.firePostSelectionChanged(event.getSelection());
            }
        });
        this.setFilterInternalTargets(this.fFilterInternalTargets);
        this.setFilterImportedElements(this.fFilterImportedElements);
        this.setFilterProperties(this.fFilterProperties);
        this.setFilterTopLevel(this.fFilterTopLevel);
    }

    private void setViewerInput(Object newInput) {
        TreeViewer tree = this.getTreeViewer();
        Object oldInput = tree.getInput();
        boolean isAntModel = newInput instanceof AntModel;
        boolean wasAntModel = oldInput instanceof AntModel;
        if (isAntModel && !wasAntModel) {
            if (this.fListener == null) {
                this.fListener = this.createAntModelChangeListener();
            }
            this.fCore.addDocumentModelListener(this.fListener);
        } else if (!isAntModel && wasAntModel && this.fListener != null) {
            this.fCore.removeDocumentModelListener(this.fListener);
            this.fListener = null;
        }
        tree.setInput(newInput);
        if (isAntModel) {
            this.updateTreeExpansion();
        }
    }

    public void setPageInput(AntModel xmlModel) {
        this.fModel = xmlModel;
        if (this.getTreeViewer() != null) {
            this.setViewerInput(this.fModel);
        }
    }

    private IDocumentModelListener createAntModelChangeListener() {
        return new IDocumentModelListener(){

            public void documentModelChanged(DocumentModelChangeEvent event) {
                if (event.getModel() == AntEditorContentOutlinePage.this.fModel && !AntEditorContentOutlinePage.this.getControl().isDisposed()) {
                    AntEditorContentOutlinePage.this.getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            Control ctrl = 3.access$1100(this.this$1).getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                AntEditorContentOutlinePage.access$1200(3.access$1100(this.this$1)).refresh();
                                AntEditorContentOutlinePage.access$1300(3.access$1100(this.this$1));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ AntEditorContentOutlinePage access$1100(3 x0) {
                return x0.AntEditorContentOutlinePage.this;
            }
        };
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove((Object)listener);
    }

    private void updateTreeExpansion() {
        boolean wasModelEmpty = this.fIsModelEmpty;
        boolean bl = this.fIsModelEmpty = this.fModel == null || this.fModel.getRootElements() == null || this.fModel.getRootElements().length == 0;
        if (wasModelEmpty && !this.fIsModelEmpty) {
            this.getTreeViewer().expandToLevel(2);
        }
    }

    private void firePostSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.fPostSelectionChangedListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
        }
    }

    private void contextMenuAboutToShow(IMenuManager menuManager) {
        if (this.shouldAddOpenWithMenu()) {
            this.addOpenWithMenu(menuManager);
        }
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void addOpenWithMenu(IMenuManager menuManager) {
        AntElementNode element = this.getSelectedNode();
        IFile file = element.getIFile();
        if (file != null) {
            menuManager.add((IContributionItem)new Separator("group.open"));
            MenuManager submenu = new MenuManager(AntOutlineMessages.getString("AntEditorContentOutlinePage.Open_With_1"));
            this.openWithMenu.setFile((IAdaptable)file);
            if (element.getImportNode() != null) {
                int[] lineAndColumn = element.getExternalInfo();
                this.openWithMenu.setExternalInfo(lineAndColumn[0], lineAndColumn[1]);
            }
            submenu.add((IContributionItem)this.openWithMenu);
            menuManager.appendToGroup("group.open", (IContributionItem)submenu);
        }
    }

    private boolean shouldAddOpenWithMenu() {
        String path;
        AntElementNode node = this.getSelectedNode();
        if (node instanceof AntImportNode) {
            return true;
        }
        return node != null && node.isExternal() && (path = node.getFilePath()) != null && path.length() > 0;
    }

    private AntElementNode getSelectedNode() {
        Object selected;
        IStructuredSelection selection;
        ISelection iselection = this.getSelection();
        if (iselection instanceof IStructuredSelection && (selection = (IStructuredSelection)iselection).size() == 1 && (selected = selection.getFirstElement()) instanceof AntElementNode) {
            return (AntElementNode)selected;
        }
        return null;
    }

    public Object getAdapter(Class key) {
        if (key == (class$org$eclipse$ui$part$IShowInSource == null ? (class$org$eclipse$ui$part$IShowInSource = AntEditorContentOutlinePage.class$("org.eclipse.ui.part.IShowInSource")) : class$org$eclipse$ui$part$IShowInSource)) {
            return this;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IFile file = null;
        if (this.fModel != null) {
            AntElementNode node = this.getSelectedNode();
            file = node.getIFile();
        }
        if (file != null) {
            StructuredSelection selection = new StructuredSelection((Object)file);
            return new ShowInContext(null, (ISelection)selection);
        }
        return null;
    }

    public void select(AntElementNode node) {
        IStructuredSelection ss;
        List nodes;
        ISelection s;
        if (this.getTreeViewer() != null && (s = this.getTreeViewer().getSelection()) instanceof IStructuredSelection && !(nodes = (ss = (IStructuredSelection)s).toList()).contains(node)) {
            s = node == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)node);
            this.getTreeViewer().setSelection(s, true);
        }
    }

    static /* synthetic */ TreeViewer access$1200(AntEditorContentOutlinePage x0) {
        return x0.getTreeViewer();
    }

    static /* synthetic */ void access$1300(AntEditorContentOutlinePage x0) {
        x0.updateTreeExpansion();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements IColorProvider {
        private LabelProvider() {
        }

        public Image getImage(Object anElement) {
            AntElementNode node = (AntElementNode)anElement;
            return node.getImage();
        }

        public String getText(Object node) {
            AntElementNode element = (AntElementNode)node;
            return element.getLabel();
        }

        public Color getForeground(Object node) {
            if (node instanceof AntTargetNode && ((AntTargetNode)node).isDefaultTarget()) {
                return Display.getDefault().getSystemColor(9);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentNode) {
            AntElementNode tempParentElement = (AntElementNode)parentNode;
            if (tempParentElement.hasChildren()) {
                List children = tempParentElement.getChildNodes();
                return children.toArray();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object aNode) {
            AntElementNode tempElement = (AntElementNode)aNode;
            return tempElement.getParentNode();
        }

        public boolean hasChildren(Object aNode) {
            return ((AntElementNode)aNode).hasChildren();
        }

        public Object[] getElements(Object anInputElement) {
            return ((AntModel)anInputElement).getRootElements();
        }
    }

    private class AntOutlineSorter
    extends ViewerSorter {
        private AntOutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof AntElementNode) || !(e2 instanceof AntElementNode)) {
                return super.compare(viewer, e1, e2);
            }
            String name1 = ((AntElementNode)e1).getLabel();
            String name2 = ((AntElementNode)e2).getLabel();
            return this.getCollator().compare(name1, name2);
        }
    }

    private class TopLevelFilter
    extends ViewerFilter {
        private TopLevelFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof AntTaskNode) || !(parentElement instanceof AntProjectNode);
        }
    }

    private class PropertiesFilter
    extends ViewerFilter {
        private PropertiesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof AntPropertyNode);
        }
    }

    private class ImportedElementsFilter
    extends ViewerFilter {
        private ImportedElementsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            AntElementNode node;
            if (element instanceof AntElementNode && ((node = (AntElementNode)element).getImportNode() != null || node.isExternal())) {
                return node instanceof AntTargetNode && ((AntTargetNode)node).isDefaultTarget();
            }
            return true;
        }
    }

    private class InternalTargetFilter
    extends ViewerFilter {
        private InternalTargetFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof AntTargetNode) {
                Target target = ((AntTargetNode)element).getTarget();
                return target.getDescription() != null || ((AntTargetNode)element).isDefaultTarget();
            }
            return true;
        }
    }
}

