/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.ek;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object jC = new Object();
    private static HashSet<Uri> jD = new HashSet();
    private static ImageManager jE;
    private static ImageManager jF;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService jG;
    private final b jH;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> jI;
    private final Map<Uri, ImageReceiver> jJ;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (jF == null) {
                jF = new ImageManager(context, true);
            }
            return jF;
        }
        if (jE == null) {
            jE = new ImageManager(context, false);
        }
        return jE;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.jG = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.jH = new b(this.mContext);
            if (ek.bM()) {
                this.aO();
            }
        } else {
            this.jH = null;
        }
        this.jI = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.jJ = new HashMap<Uri, ImageReceiver>();
    }

    private void aO() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.jH));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, int resId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(resId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.v(defaultResId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(listener);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.v(defaultResId);
        a2.a(listener);
        this.a(a2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        db.w("ImageManager.loadImage() must be called in the main thread");
        boolean bl2 = this.b(a2);
        d d2 = new d(a2);
        if (bl2) {
            d2.run();
        } else {
            this.mHandler.post((Runnable)d2);
        }
    }

    private boolean b(com.google.android.gms.common.images.a a2) {
        db.w("ImageManager.cleanupHashMaps() must be called in the main thread");
        if (a2.jV == 1) {
            return true;
        }
        ImageReceiver imageReceiver = this.jI.get(a2);
        if (imageReceiver == null) {
            return true;
        }
        if (imageReceiver.jL) {
            return false;
        }
        this.jI.remove(a2);
        imageReceiver.d(a2);
        return true;
    }

    private Bitmap a(a.a a2) {
        if (this.jH == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.jH.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class b
    extends dq<a.a, Bitmap> {
        public b(Context context) {
            super(b.q(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int q(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && ek.bJ() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b jH;

        public e(b b2) {
            this.jH = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.jH.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.jH.evictAll();
            } else if (level >= 20) {
                this.jH.trimToSize(this.jH.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap jP;
        private final CountDownLatch jQ;
        private boolean jR;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.jP = bitmap;
            this.jR = bl2;
            this.jQ = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            db.w("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.jP != null;
            if (ImageManager.this.jH != null) {
                if (this.jR) {
                    ImageManager.this.jH.evictAll();
                    System.gc();
                    this.jR = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.jH.put(new a.a(this.mUri), this.jP);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.jJ.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.jQ.countDown();
            Object object = jC;
            synchronized (object) {
                jD.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            imageReceiver.jL = true;
            ArrayList arrayList = imageReceiver.jK;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.jP, false);
                } else {
                    a2.b(ImageManager.this.mContext, false);
                }
                if (a2.jV == 1) continue;
                ImageManager.this.jI.remove(a2);
            }
            imageReceiver.jL = false;
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor jN;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.jN = parcelFileDescriptor;
        }

        public void run() {
            db.x("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.jN != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.jN.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.jN.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> jK;
        boolean jL;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.jL = false;
            this.mUri = uri;
            this.jK = new ArrayList();
        }

        public void c(com.google.android.gms.common.images.a a2) {
            db.a(!this.jL, "Cannot add an ImageRequest when mHandlingRequests is true");
            db.w("ImageReceiver.addImageRequest() must be called in the main thread");
            this.jK.add(a2);
        }

        public void d(com.google.android.gms.common.images.a a2) {
            db.a(!this.jL, "Cannot remove an ImageRequest when mHandlingRequests is true");
            db.w("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.jK.remove(a2);
        }

        public void aR() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.jG.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a jO;

        public d(com.google.android.gms.common.images.a a2) {
            this.jO = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            db.w("LoadImageRunnable must be executed on the main thread");
            ImageManager.this.b(this.jO);
            a.a a2 = this.jO.jS;
            if (a2.uri == null) {
                this.jO.b(ImageManager.this.mContext, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.jO.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            this.jO.r(ImageManager.this.mContext);
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.jJ.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.jJ.put(a2.uri, imageReceiver);
            }
            imageReceiver.c(this.jO);
            if (this.jO.jV != 1) {
                ImageManager.this.jI.put(this.jO, imageReceiver);
            }
            boolean bl2 = false;
            Object object = jC;
            synchronized (object) {
                bl2 = jD.contains(a2.uri);
                if (!bl2) {
                    jD.add(a2.uri);
                    imageReceiver.aR();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2);
    }
}

